### Name: IRanges-constructor
### Title: The IRanges constructor and supporting functions
### Aliases: IRanges-constructor IRanges solveUserSEW0 solveUserSEW
### Keywords: utilities

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. USING THE IRanges() CONSTRUCTOR
  ## ---------------------------------------------------------------------
  IRanges(start=11, end=rep.int(20, 5))
  IRanges(start=11, width=rep.int(20, 5))
  IRanges(-2, 20)  # only one range
  IRanges(start=c(2, 0, NA), end=c(NA, NA, 14), width=11:0)
  IRanges()  # IRanges instance of length zero
  IRanges(names=character())

  ## With logical input:
  x <- IRanges(c(FALSE, TRUE, TRUE, FALSE, TRUE))  # logical vector input
  isNormal(x)  # TRUE
  x <- IRanges(Rle(1:30) %% 5 <= 2)  # logical Rle input
  isNormal(x)  # TRUE

  ## ---------------------------------------------------------------------
  ## B. USING solveUserSEW()
  ## ---------------------------------------------------------------------
  refwidths <- c(5:3, 6:7)
  refwidths

  solveUserSEW(refwidths)
  solveUserSEW(refwidths, start=4)
  solveUserSEW(refwidths, end=3, width=2)
  solveUserSEW(refwidths, start=-3)
  solveUserSEW(refwidths, start=-3, width=2)
  solveUserSEW(refwidths, end=-4)

  ## The start/end/width arguments are expanded cyclically
  solveUserSEW(refwidths, start=c(3, -4, NA), end=c(-2, NA))



