### Name: hilbertImage
### Title: Produce a matrix that visualizes a long data vector along a
###   Hilbert curve
### Aliases: hilbertImage


### ** Examples

   # Get a vector with example data
   dataVec <- makeRandomTestData( )
   
   # Plot it in conventional (linear) fashion
   plotLongVector( dataVec )
   
   # Note how the peaks look quite uniform

   # Get the Hilbert curve matrix
   hMat <- hilbertImage( dataVec )
   
   # Plot it with the 'showHilbertImage' function
   showHilbertImage( hMat )
   
   # Note how you can now see the non-uniformity hidden in the previous plot.
   # Note also the ugly aliasing when you change the size of the plot window.
   # Using EBImage allows to display in each matrix element as one pixel:
   
   # if( require ( EBImage ) )
   #    showHilbertImage( hMat, mode="EBImage" )



