### Name: GSload.genelist
### Title: Load and save GeneSpring gene lists
### Aliases: GSload.genelist GSsave.genelist
### Keywords: IO

### ** Examples

#Create a simple GeneList
glist <- c("160640_at","101906_at", "104099_at")
#Save the genelist to a file
GSsave.genelist(glist, filename = "GS_R_out.txt")
#Load the genelist again
g2 <- GSload.genelist(filename = "GS_R_out.txt")
#Add some values to the genelist as associated values by making a data.frame out of it
g3 <- data.frame(genes = g2, value=rnorm(3))
#Save the genelist again to the default file ("GS_R_out.txt") and append it to the file
GSsave.genelist(g3, append=TRUE)
#Load the gene list and display
GSload.genelist(filename = "GS_R_out.txt", chunk=2)

#Create classification style gene list
g4 <- data.frame(genes = g2, classification=c("Cluster 1","Cluster 2", "Cluster 1"))
GSsave.genelist(g4, append=FALSE)
#Load the gene list and display
GSload.genelist(filename = "GS_R_out.txt")



