### Name: gsMMD.default
### Title: Gene selection based on a mixture of marginal distributions
### Aliases: gsMMD.default
### Keywords: classif

### ** Examples

  library(ALL)
  data(ALL)
  eSet1 <- ALL[1:100, ALL$BT == "B3" | ALL$BT == "T2"]
  mat <- exprs(eSet1)
  
  mem.str <- as.character(eSet1$BT)
  nSubjects <- length(mem.str)
  memSubjects <- rep(0,nSubjects)
  # B3 coded as 0, T2 coded as 1
  memSubjects[mem.str == "T2"] <- 1
 
  obj.gsMMD <- gsMMD.default(mat, memSubjects, iniGeneMethod = "Ttest",
          transformFlag = TRUE, transformMethod = "boxcox", scaleFlag = TRUE)
  round(obj.gsMMD$para, 3)



