### Name: geneRegionScan
### Title: Gene Region Scan
### Aliases: geneRegionScan GeneRegionScan
###   geneRegionScan,ExpressionSet-method
### Keywords: documentation utilities

### ** Examples


        data(exampleProbeLevelSet)
        
        #simple:
        geneRegionScan(exampleProbeLevelSet,mrna)
        
        #more complicated - note that we slice the mrna to simulate comparing two different isoforms
        gene1<-DNAString(mrna[[1]]$seq)[1:1000]
        gene2<-DNAString(mrna[[1]]$seq)[1500:3000]
        
        geneRegionScan(exampleProbeLevelSet, list(gene1,gene2), genomicData=list(genomic,genomic), label="genotype3", summaryType="mean",
    testType="linear model", forcePValue=TRUE, cutoff=0.1, directions="all", correlationCutoff=0.6,
    probeLevelInfo=c("probeid","sequence"))



