### Name: GeneSetCollection-methods
### Title: Methods to construct GeneSetCollection instances
### Aliases: GeneSetCollection GeneSetCollection-methods
###   GeneSetCollection,GeneSet,missing,missing-method
###   GeneSetCollection,list,missing,missing-method
###   GeneSetCollection,character,AnnotationIdentifier,CollectionType-metho
###   d
###   GeneSetCollection,character,AnnotationIdentifier,CollectionIdType-met
###   hod
###   GeneSetCollection,character,AnnotationIdentifier,PfamCollection-metho
###   d
###   GeneSetCollection,character,AnnotationIdentifier,PrositeCollection-me
###   thod
###   GeneSetCollection,character,AnnotationIdentifier,ChrlocCollection-met
###   hod GeneSetCollection,ExpressionSet,missing,CollectionType-method
###   GeneSetCollection,ExpressionSet,missing,CollectionIdType-method
###   GeneSetCollection,ExpressionSet,missing,KEGGCollection-method
###   GeneSetCollection,ExpressionSet,missing,GOCollection-method
###   GeneSetCollection,ExpressionSet,missing,PfamCollection-method
###   GeneSetCollection,ExpressionSet,missing,PrositeCollection-method
###   GeneSetCollection,ExpressionSet,missing,ChrlocCollection-method
###   GeneSetCollection,missing,AnnotationIdentifier,CollectionType-method
###   GeneSetCollection,missing,AnnotationIdentifier,CollectionIdType-metho
###   d
###   GeneSetCollection,missing,AnnotationIdentifier,KEGGCollection-method
###   GeneSetCollection,missing,AnnotationIdentifier,GOCollection-method
### Keywords: methods

### ** Examples

gs1 <- GeneSet(setName="set1", setIdentifier="101")
gs2 <- GeneSet(setName="set2", setIdentifier="102")

## construct from indivdiual elements...
gsc <- GeneSetCollection(gs1, gs2)
## or from a list
gsc <- GeneSetCollection(list(gs1, gs2))

## set names must be unique
try(GeneSetCollection(gs1, gs1))

data(sample.ExpressionSet)
gsc <- GeneSetCollection(sample.ExpressionSet[200:250],
                         setType = GOCollection())

## Not run: 
##D ## from KEGG identifiers, for example
##D library(KEGG.db)
##D lst <- head(as.list(KEGGEXTID2PATHID))
##D gsc <- GeneSetCollection(mapply(function(geneIds, keggId) {
##D     GeneSet(geneIds, geneIdType=EntrezIdentifier(),
##D             collectionType=KEGGCollection(keggId),
##D             setName=keggId)
##D }, lst, names(lst)))
## End(Not run)



