###################################################
### chunk number 1: 
###################################################
options(width=60)


###################################################
### chunk number 2: 
###################################################
library(ChemmineR)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## library(help=ChemmineR)
## options(chemminer.max.upload=100)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## vignette("ChemmineR")


###################################################
### chunk number 5: 
###################################################
library(ChemmineR)
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf", quiet=TRUE)


###################################################
### chunk number 6:  eval=FALSE
###################################################
## save(db, file="compounddb.rda", compress=TRUE)


###################################################
### chunk number 7:  eval=FALSE
###################################################
## load("compounddb.rda")


###################################################
### chunk number 8: 
###################################################
query.url <- "http://bioweb.ucr.edu/ChemMineV2/compound/Aurora/b32:NNQS2MBRHAZTI===/sdf"
query <- cmp.parse1(query.url)


###################################################
### chunk number 9: 
###################################################
class(query)


###################################################
### chunk number 10: 
###################################################
names(db)


###################################################
### chunk number 11: 
###################################################
class(db$descdb)
class(db$descdb[[1]])


###################################################
### chunk number 12: 
###################################################
db.explain(query[1])
db.explain(db$descdb[[1]][1])


###################################################
### chunk number 13: 
###################################################
db.explain(db$descdb[[1]][1:5])


###################################################
### chunk number 14: 
###################################################
db$descdb <- c(db$descdb, list(db$descdb[[1]])) 


###################################################
### chunk number 15: 
###################################################
dup <- cmp.duplicated(db)
dup


###################################################
### chunk number 16: 
###################################################
db$descdb <- db$descdb[!dup]


###################################################
### chunk number 17:  eval=FALSE
###################################################
## db$cids <- db$cids[!dup]
## db$sdfsegs <- db$sdfsegs[!dup]


###################################################
### chunk number 18: 
###################################################
similarity <- cmp.similarity(db$descdb[[1]], db$descdb[[2]])
cat(paste("The similarity between compound 1 and 2 is ", similarity, "\n", sep=""))
similarity <- cmp.similarity(db$descdb[[1]], query)
cat(paste("The similarity between compound 1 and the query is ", similarity, "\n", sep=""))


###################################################
### chunk number 19: 
###################################################
cmp.search(db, query, cutoff=0.4, return.score=TRUE, quiet=TRUE)


###################################################
### chunk number 20:  eval=FALSE
###################################################
## similarities <- cmp.search(db, db[[1]][[1]], cutoff =0, return.score=TRUE, quiet=TRUE) 


###################################################
### chunk number 21:  eval=FALSE
###################################################
## similarities <- cmp.search(db, query, cutoff=10, quiet=TRUE, visualize=TRUE, visualize.browse=FALSE) 


###################################################
### chunk number 22:  eval=FALSE
###################################################
## similarities <- cmp.search(db, query, cutoff=10, quiet=TRUE, visualize=TRUE, visualize.browse=TRUE, visualize.query=query.url) 


###################################################
### chunk number 23: 
###################################################
indices <- cmp.search(db, query, cutoff=10, quiet=TRUE)


###################################################
### chunk number 24:  eval=FALSE
###################################################
## url <- sdf.visualize(db, indices, browse=TRUE, quiet=TRUE)


###################################################
### chunk number 25: 
###################################################
url <- sdf.visualize(db, indices, browse=FALSE, quiet=TRUE)


###################################################
### chunk number 26: 
###################################################
url


###################################################
### chunk number 27: 
###################################################
extra.info <- paste("Matching compound #", 1:length(indices), sep="")
names(extra.info) <- rep("Note", length(indices))


###################################################
### chunk number 28:  eval=FALSE
###################################################
## url <- sdf.visualize(db, indices, browse=TRUE, quiet=TRUE, extra=extra.info)


###################################################
### chunk number 29: 
###################################################
url <- sdf.visualize(db, indices, browse=FALSE, quiet=TRUE, extra=extra.info)


###################################################
### chunk number 30: 
###################################################
url


###################################################
### chunk number 31:  eval=FALSE
###################################################
## url <- sdf.visualize(db, indices, browse=TRUE, quiet=TRUE, reference.sdf=query.url, reference.note="Reference Compound from Aurora Library")


###################################################
### chunk number 32: 
###################################################
url <- sdf.visualize(db, indices, browse=FALSE, quiet=TRUE, reference.sdf=query.url, reference.note="Reference Compound from Aurora Library")


###################################################
### chunk number 33: 
###################################################
url


###################################################
### chunk number 34: 
###################################################
search.results <- cmp.search(db, query, cutoff=0, return.score=T, quiet=T)


###################################################
### chunk number 35: 
###################################################
note.q <- list(search.results)
names(note.q) <- "Similarities With All"


###################################################
### chunk number 36: 
###################################################
indices <- search.results[1:10,1]
notes <- list()
for (i in indices) {
  search.results <- cmp.search(db, db$descdb[[i]], 0, return.score=T, quiet=T)
  notes <- c(notes, list(search.results))
}
names(notes) <- rep("Similarities With All", 10)


###################################################
### chunk number 37:  eval=FALSE
###################################################
## url <- sdf.visualize(db, indices, extra=notes, browse=T, reference.sdf=query.url, reference.note=note.q)


###################################################
### chunk number 38: 
###################################################
indices <- cmp.search(db, query, cutoff=10, quiet=TRUE)


###################################################
### chunk number 39: >
###################################################
sdf <- sdf.subset(db, indices)
cat(sdf, file="matching.sdf")


###################################################
### chunk number 40: >
###################################################
db_sub <- db.subset(db, indices)


###################################################
### chunk number 41: 
###################################################
clusters <- cmp.cluster(db, cutoff=0.65, quiet=TRUE)


###################################################
### chunk number 42: 
###################################################
clusters[1:10,]


###################################################
### chunk number 43: 
###################################################
clusters[clusters[,3]==1,]


###################################################
### chunk number 44:  eval=FALSE
###################################################
## ids <- clusters[clusters[,3]==23, 1]
## sdf.visualize(db, ids, browse=TRUE, quiet=TRUE)


###################################################
### chunk number 45: 
###################################################
clusters <- cmp.cluster(db, cutoff=c(0.65, 0.5), quiet=TRUE)


###################################################
### chunk number 46: 
###################################################
clusters[1:10,]


###################################################
### chunk number 47: 
###################################################
clusters[clusters[, "CLID_0.65"]==14,]


###################################################
### chunk number 48: 
###################################################
clusters[clusters[, "CLID_0.5"]==14,]


###################################################
### chunk number 49: 
###################################################
cluster.sizestat(clusters)


###################################################
### chunk number 50: 
###################################################
coord <- cluster.visualize(db, clusters, 3, quiet=TRUE)


###################################################
### chunk number 51:  eval=FALSE
###################################################
## coord <- cluster.visualize(db, clusters, 3, dimensions=3, quiet=TRUE)
## library(scatterplot3d)
## scatterplot3d(coord)


###################################################
### chunk number 52:  eval=FALSE
###################################################
## library(rggobi)
## ggobi(coord)


###################################################
### chunk number 53: 
###################################################
dummy <- cmp.cluster(db, 0, save.distances="distmat.rda", quiet=T)


###################################################
### chunk number 54: 
###################################################
load('distmat.rda')
hc <- hclust(as.dist(distmat), "single")
plot(as.dendrogram(hc), horiz=T)


