### Name: complementSeq
### Title: Complementary sequence.
### Aliases: complementSeq
### Keywords: manip

### ** Examples

  ## ---------------------------------------------------------------------
  ## EXAMPLE 1
  ## ---------------------------------------------------------------------
  seq <- c("AAACT", "GGGTT")

  ## Don't do this anymore (deprecated):
  if (interactive()) {
    complementSeq(seq)  # inefficient on large vectors
  }
  ## But do this instead:
  complement(DNAStringSet(seq))  # more efficient

  ## ---------------------------------------------------------------------
  ## EXAMPLE 2
  ## ---------------------------------------------------------------------
  seq <- c("CGACTGAGACCAAGACCTACAACAG", "CCCGCATCATCTTTCCTGTGCTCTT")

  ## Don't do this anymore (deprecated):
  if (interactive()) {
    complementSeq(seq, start=13, stop=13)
  }
  ## But do this instead:
  pm2mm <- function(probes)
  {
      probes <- DNAStringSet(probes)
      subseq(probes, start=13, end=13) <- complement(subseq(probes, start=13, end=13))
      probes
  }
  pm2mm(seq) 

  ## ---------------------------------------------------------------------
  ## SPEED OF complementSeq() VS complement()
  ## ---------------------------------------------------------------------
  if (interactive()) {
    library(hgu95av2probe)
    system.time(y1 <- complementSeq(hgu95av2probe$sequence))
    probes <- DNAStringSet(hgu95av2probe$sequence)
    system.time(y2 <- complement(probes))
  }



