### Name: align-utils
### Title: Utility functions related to sequence alignment
### Aliases: align-utils mismatch,AlignedXStringSet0,missing-method
###   nmatch,PairwiseAlignedXStringSet,missing-method
###   nmatch,PairwiseAlignedFixedSubjectSummary,missing-method
###   nmismatch,AlignedXStringSet0,missing-method
###   nmismatch,PairwiseAlignedXStringSet,missing-method
###   nmismatch,PairwiseAlignedFixedSubjectSummary,missing-method nedit
###   nedit,PairwiseAlignedXStringSet-method
###   nedit,PairwiseAlignedFixedSubjectSummary-method mismatchTable
###   mismatchTable,AlignedXStringSet0-method
###   mismatchTable,QualityAlignedXStringSet-method
###   mismatchTable,PairwiseAlignedXStringSet-method mismatchSummary
###   mismatchSummary,AlignedXStringSet0-method
###   mismatchSummary,QualityAlignedXStringSet-method
###   mismatchSummary,PairwiseAlignedFixedSubject-method
###   mismatchSummary,PairwiseAlignedFixedSubjectSummary-method
###   coverage,AlignedXStringSet0-method
###   coverage,PairwiseAlignedFixedSubject-method
###   coverage,PairwiseAlignedFixedSubjectSummary-method compareStrings
###   compareStrings,character,character-method
###   compareStrings,XString,XString-method
###   compareStrings,XStringSet,XStringSet-method
###   compareStrings,AlignedXStringSet0,AlignedXStringSet0-method
###   compareStrings,PairwiseAlignedXStringSet,missing-method
###   consensusMatrix,PairwiseAlignedFixedSubject-method
### Keywords: methods

### ** Examples

  ## Compare two globally aligned strings
  string1 <- "ACTTCACCAGCTCCCTGGCGGTAAGTTGATC---AAAGG---AAACGCAAAGTTTTCAAG"
  string2 <- "GTTTCACTACTTCCTTTCGGGTAAGTAAATATATAAATATATAAAAATATAATTTTCATC"
  compareStrings(string1, string2)

  ## Create a consensus matrix
  nw1 <-
    pairwiseAlignment(AAStringSet(c("HLDNLKGTF", "HVDDMPNAL")), AAString("SMDDTEKMSMKL"),
      substitutionMatrix = "BLOSUM50", gapOpening = -3, gapExtension = -1)
  consensusMatrix(nw1)

  ## Examine the consensus between the bacteriophage phi X174 genomes
  data(phiX174Phage)
  phageConsmat <- consensusMatrix(phiX174Phage, baseOnly = TRUE)
  phageDiffs <- which(apply(phageConsmat, 2, max) < length(phiX174Phage))
  phageDiffs
  phageConsmat[,phageDiffs]



