### Name: chartr
### Title: Translating letters of a sequence
### Aliases: chartr,ANY,ANY,XString-method chartr,ANY,ANY,XStringSet-method
###   chartr,ANY,ANY,XStringViews-method
###   chartr,ANY,ANY,MaskedXString-method
### Keywords: methods manip

### ** Examples

  x <- BString("MiXeD cAsE 123")
  chartr("iXs", "why", x)

  ## ---------------------------------------------------------------------
  ## TRANSFORMING DNA WITH BISULFITE (AND SEARCHING IT...)
  ## ---------------------------------------------------------------------

  library(BSgenome.Celegans.UCSC.ce2)
  chrII <- Celegans[["chrII"]]
  alphabetFrequency(chrII)
  pattern <- DNAString("TGGGTGTATTTA")

  ## Transforming and searching the + strand
  plus_strand <- chartr("C", "T", chrII)
  alphabetFrequency(plus_strand)
  matchPattern(pattern, plus_strand)
  matchPattern(pattern, chrII)

  ## Transforming and searching the - strand
  minus_strand <- chartr("G", "A", chrII)
  alphabetFrequency(minus_strand)
  matchPattern(reverseComplement(pattern), minus_strand)
  matchPattern(reverseComplement(pattern), chrII)



