### Name: bcrank
### Title: BCRANK: predicting binding site consensus from ranked DNA
###   sequences
### Aliases: bcrank
### Keywords: methods

### ** Examples

## Load example fasta file  
fastaFile <- system.file("Exfiles/USF1_small.fa", package = "BCRANK") 
## Run BCRANK
## Not run: BCRANKout <- bcrank(fastaFile, restarts=20)
## Don't show: 
data(BCRANKout)
## End Don't show
## Show BCRANK results
toptable(BCRANKout)
## The top scoring result
topMotif <- toptable(BCRANKout,1)
## Plot BCRANK search path
plot(topMotif)
## Position Weight Matrix
pwm(topMotif, normalize=FALSE)



