###################################################
### chunk number 1: 
###################################################
library(ArrayTools)
data(exprsExample)
head(exprsExample)
dim(exprsExample)
data(pDataExample)
pDataExample


###################################################
### chunk number 2: 
###################################################
rownames(exprsExample) <- exprsExample$probeset_id
eSet <- createExpressionSet (pData=pDataExample,  exprs = exprsExample, annotation = "hugene10sttranscriptcluster")
dim(eSet)


###################################################
### chunk number 3: 
###################################################
normal <- preProcessGeneST (eSet, output=TRUE)
normal
dim(normal)


###################################################
### chunk number 4: 
###################################################
data(QC)
qaGeneST(normal, c("Treatment", "Group"), QC)


###################################################
### chunk number 5: 
###################################################
filtered <- geneFilter(normal, numChip = 2, bg = 4, iqrPct=0.1,  output=TRUE)


###################################################
### chunk number 6: 
###################################################
design1<- new("designMatrix", target=pData(filtered), covariates = "Treatment")
design1


###################################################
### chunk number 7: 
###################################################
design2<- new("designMatrix", target=pData(filtered), covariates = c("Treatment", "Group"))
design2


###################################################
### chunk number 8: 
###################################################
contrast1 <- new("contrastMatrix", design.matrix = design1,  compare1 = "Treated", compare2 = "Control")
contrast1


###################################################
### chunk number 9: 
###################################################
contrast2 <- new("contrastMatrix", design.matrix = design2, compare1 = "Treated", compare2 = "Control")
contrast2


###################################################
### chunk number 10: 
###################################################
result1 <- regress(filtered, contrast1)
result2 <- regress(filtered, contrast2)


###################################################
### chunk number 11: 
###################################################
sigResult1 <- selectSigGene(result1, p.value=0.05, fc.value=log2(1.5))
sigResult2 <- selectSigGene(result2, p.value=0.05, fc.value=log2(1.5))


###################################################
### chunk number 12: 
###################################################
Sort(sigResult1, sorted.by = 'pValue')
Sort(sigResult2, sorted.by = 'F')


###################################################
### chunk number 13: 
###################################################
Output2HTML(sigResult1)
Output2HTML(sigResult2)


###################################################
### chunk number 14: 
###################################################
designInt <- new("designMatrix", target=pData(filtered), covariates = c("Treatment", "Group"), intIndex=c(1,2))
designInt
contrastInt <- new("contrastMatrix", design.matrix = designInt, interaction = TRUE)
contrastInt


###################################################
### chunk number 15: 
###################################################
resultInt <- regress(filtered, contrastInt)
sigResultInt <-selectSigGene(resultInt, p.value=0.05, fc.value=log2(1.5))


###################################################
### chunk number 16: 
###################################################
intResult <- postInteraction(filtered, sigResultInt, mainVar ="Treatment",  compare1 = "Treated",  compare2 = "Control")
sigResultInt <- selectSigGeneInt(intResult, pGroup = 0.05, pMain = 0.05)


###################################################
### chunk number 17: 
###################################################
Output2HTML(sigResultInt)


###################################################
### chunk number 18: 
###################################################
createIndex (sigResult1, sigResult2, intResult)


