### Name: make.contrast
### Title: Create a contrast matrix
### Aliases: make.contrast
### Keywords: array

### ** Examples

target<-data.frame(drug=(c(rep("A",4),rep("B",4),rep("C",4))), 
gender=factor(c(rep("M",6),rep("F",6))), 
group=factor(rep(c(1,2,3),4)))

# Example1:  Compare drug "A" vs. "B"
design1<-make.design(target, "drug")
contrast1<-make.contrast(design1, "A", "B")

# Example2:  Compare drug "A" vs. "B", adjusting for "group" variable
design2<-make.design(target, c("drug","group"))
contrast2<-make.contrast(design2, "A", "B")

# Example3:  Suppose you are interested in "drug", "group" interaction
design3<-make.design(target, c("drug","group"), int=c(1,2))
contrast3<-make.contrast(design3, interaction=TRUE)

# Example4:  Compare drug "A" vs. "B" among "male"
# Notice that you must use an design matrix containing an interaction term
design4<-make.design(target, c("drug","gender"), int=c(1,2))
contrast4<-make.contrast(design4, "A", "B", "M")



