### Name: rma
### Title: Robust Multi-Array Average Expression Measure
### Aliases: rma xpsRMA-methods xpsRMA
### Keywords: manip

### ** Examples

## first, load ROOT scheme file and ROOT data file
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))

data.rma <- rma(data.test3,"tmp_Test3RMA",tmpdir="",background="pmonly",normalize=TRUE,verbose=FALSE)

## get data.frame
expr.rma <- validData(data.rma)
head(expr.rma)

## plot results
if (interactive()) {
boxplot(data.rma)
boxplot(log2(expr.rma))
}

rm(scheme.test3, data.test3)
gc()

## Not run: 
##D ## examples using Affymetrix human tissue dataset (see also xps/examples/script4exon.R)
##D ## first, load ROOT scheme file and ROOT data file from e.g.:
##D scmdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Schemes"
##D datdir <- "/Volumes/GigaDrive/CRAN/Workspaces/ROOTData"
##D 
##D ## 1. example - expression array, e.g. HG-U133_Plus_2:
##D scheme.u133p2 <- root.scheme(paste(scmdir,"Scheme_HGU133p2_na25.root",sep="/"))
##D data.u133p2   <- root.data(scheme.u133p2, paste(datdir,"HuTissuesU133P2_cel.root",sep="/"))
##D 
##D workdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Exon/hutissues/u133p2"
##D data.rma <- rma(data.u133p2,"MixU133P2RMA",filedir=workdir,tmpdir="",
##D                 background="pmonly",normalize=TRUE)
##D 
##D ## 2. example - whole genome array, e.g. HuGene-1_0-st-v1:
##D scheme.genome <- root.scheme(paste(scmdir,"Scheme_HuGene10stv1r3_na25.root",sep="/"))
##D data.genome   <- root.data(scheme.genome, paste(datdir,"HuTissuesGenome_cel.root",sep="/"))
##D 
##D workdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Exon/hutissues/hugene"
##D data.g.rma <- rma(data.genome,"HuGeneMixRMAMetacore",filedir=workdir,tmpdir="",
##D                   background="antigenomic",normalize=T,exonlevel="metacore+affx")
##D 
##D ## 3. example - exon array, e.g. HuEx-1_0-st-v2:
##D scheme.exon <- root.scheme(paste(scmdir,"Scheme_HuEx10stv2r2_na25.root",sep="/"))
##D data.exon   <- root.data(scheme.exon, paste(datdir,"HuTissuesExon_cel.root",sep="/"))
##D 
##D workdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Exon/hutissues/exon"
##D data.x.rma <- rma(data.exon,"MixRMAMetacore",filedir=workdir,tmpdir="",background="antigenomic",
##D                   normalize=T,option="transcript",exonlevel="metacore")
## End(Not run)



