### Name: exprs-methods
### Title: Get/Set Expression Values
### Aliases: exprs-methods exprs exprs<-
### Keywords: methods

### ** Examples

## Not run: 
##D ## load ROOT scheme file and ROOT data file
##D scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
##D data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))
##D 
##D ## create an ExprTreeSet
##D data.rma <- rma(data.test3,"tmp_TestRMA",tmpdir="",background="pmonly",normalize=TRUE,verbose=FALSE)
##D 
##D ## get expression values
##D value <- exprs(data.rma)
##D 
##D ## selected treenames only
##D treenames <- c("TestA2", "TestB1")
##D 
##D ## make a copy of your object if you do not want to replace it
##D subset.rma <- data.rma
##D 
##D ## replace slot data with subset
##D exprs(subset.rma, treenames) <- value
##D str(subset.rma)
## End(Not run)



