### Name: pumaDE
### Title: Calculate differential expression between conditions
### Aliases: pumaDE
### Keywords: manip

### ** Examples

        #       Next 4 lines commented out to save time in package checks, and saved version used
    # if (require(affydata)) {
        #       data(Dilution)
        #       eset_mmgmos <- mmgmos(Dilution)
        # }
        data(eset_mmgmos)

        #       Next line shows that eset_mmgmos has 4 arrays, each of which is a different
        #   condition (the experimental design is a 2x2 factorial, with both liver and
        #       scanner factors)
        pData(eset_mmgmos)
        
        #       Next line shows expression levels of first 3 probe sets
        exprs(eset_mmgmos)[1:3,]

        #       Next line used so eset_mmgmos only has information about the liver factor
        #       The scanner factor will thus be ignored, and the two arrays of each level
        #       of the liver factor will be treated as replicates
        pData(eset_mmgmos) <- pData(eset_mmgmos)[,1,drop=FALSE]

        #       To save time we'll just use 100 probe sets for the example
        eset_mmgmos_100 <- eset_mmgmos[1:100,]
        eset_comb <- pumaComb(eset_mmgmos_100)

        pumaDEResults <- pumaDE(eset_comb)

        topGeneIDs(pumaDEResults,6) # Gives probeset identifiers
        topGenes(pumaDEResults,6) # Gives row numbers
        statistic(pumaDEResults)[topGenes(pumaDEResults,6),] # PPLR scores of top six genes
        FC(pumaDEResults)[topGenes(pumaDEResults,6),] # Fold-change of top six genes



