### Name: nudge2
### Title: Function for normalizing data, fitting a normal-uniform mixture
###   and estimating probabilities of differential expression in the case
###   where the two samples are being compared indirectly through a common
###   reference sample
### Aliases: nudge2
### Keywords: cluster loess

### ** Examples

apo<-read.csv("http://www.stat.berkeley.edu/users/terry/zarray/Data/ApoA1/rg_a1ko_morph.txt",
header=TRUE)
rownames(apo)<-apo[,1]
apo<-apo[,-1]
apo<-apo+1

lRctl<-log(apo[,c(seq(2,16,2))],2)-log(apo[,c(seq(1,15,2))],2)
lRtxt<-log(apo[,c(seq(18,32,2))],2)-log(apo[,c(seq(17,31,2))],2)
lIctl<-log(apo[,c(seq(2,16,2))],2)+log(apo[,c(seq(1,15,2))],2)
lItxt<-log(apo[,c(seq(18,32,2))],2)+log(apo[,c(seq(17,31,2))],2)
 
result<-nudge2(lRctl,lRtxt,lIctl,lItxt)




