###################################################
### chunk number 1: 
###################################################

library(minet)

data(syn.data)
#Mutual information estimation
estimator="mi.empirical"
mim <- build.mim(syn.data,estimator)
mim[1:5,1:5]


###################################################
### chunk number 2: 
###################################################

library(minet)

data(syn.data)
#Data discretization
disc <- "equalwidth"
nbins <- sqrt(nrow(syn.data))
ew.data <- discretize(syn.data,disc,nbins)
syn.data[1:5,1:5]
ew.data[1:5,1:5]


###################################################
### chunk number 3: 
###################################################
disc <- "equalfreq"
ef.data <- discretize(syn.data,disc,nbins)
ef.data[1:5,1:5]


###################################################
### chunk number 4: 
###################################################
#Network Inference
net <- mrnet(mim)
net[1:5,1:5]


###################################################
### chunk number 5: 
###################################################
library(minet)
data(syn.data)
net <- minet(syn.data, 
             method="mrnet", 
             estimator="mi.empirical", 
             disc="equalwidth", 
             nbins=sqrt(nrow(syn.data)))
net[1:5,1:5]


###################################################
### chunk number 6: 
###################################################
library(minet)
data(syn.data)
data(syn.net)
net <- minet(syn.data)
#Infered network validation
table <- validate(net, syn.net, steps=20)
table[1:10,]


###################################################
### chunk number 7: 
###################################################
library(minet)
data(syn.data)
data(syn.net)
net1 <- minet(syn.data,method="mrnet")
net2 <- minet(syn.data,method="clr")
#Infered network validation
table1 <- validate(net1, syn.net, steps=50)
table2 <- validate(net2, syn.net, steps=50)


###################################################
### chunk number 8: 
###################################################
#Precision recall curves
dev <- show.pr( table1, pch=2, type="b", col="green" )
show.pr( table2, device=dev, pch=1, type="b", col="blue")
#ROC curves
dev <- show.roc( table1, type="b", col="green" )
show.roc( table2,device=dev,type="b",col="blue" )


###################################################
### chunk number 9: 
###################################################
library(minet)
#library(graph)
#library(Rgraphviz)
data(syn.data)
net <- minet( dataset=syn.data, method="aracne", estimator="mi.mm" )
# These functions are not from the minet package:
n <- list(fillcolor="lightgreen",fontsize=20,fontcolor="red",height=.4,width=.4,fixedsize=F)
#graph <- as(net, "graphNEL")
#plot(graph, attrs = list(node=n), main="Infered Network")


