### Name: contrasts
### Title: Construct appropriate lambda matrix and test linear contrasts of
###   the parameter estimates from a linear model.
### Aliases: contrastTest par2lambda
### Keywords: models design htest

### ** Examples


data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]   
fit <- lm(exprs(estrogen)["40079_at",] ~ ES + TIME + ES*TIME)
betaNames <- names(coef(fit))
betas <- list(c("ESP"),c("ESP","ESP:TIME48h"))
coefs <- list(c(1),c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
contrastTest(fit,lambda)




