### Name: gene.graph
### Title: Use the X:Map database to find annotated gene structure and
###   generate a plot
### Aliases: gene.graph gene.graph
### Keywords: misc

### ** Examples
 
## Not run: 
##D    xmapConnect()
##D    data(exonmap)
##D    par(mfrow=c(3,2))
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1:3,4:6),type="mean-fc",gp.col="red")
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1:3,4:6),type="mean-int",gp.col=c("red","orange"))
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1,2,3,4,5,6),type="mean-int",gp.col=1:6)
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1,2,3,4,5,6),type="mean-int",gp.col=1:6,by.order=TRUE)
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1,2,3,4,5,6),type="mean-int",gp.col=1:6,by.order=TRUE,show.introns=TRUE)
##D    gene.graph("ENSG00000141510",x.rma,gps=list(1,2,3,4,5,6),type="mean-int",gp.col=c(rep("red",3),rep("orange",3)),gp.pch=c(1,1,1,2,2,2),by.order=TRUE,show.introns=TRUE,exon.bg.col=NA)
## End(Not run)



