### Name: ROC
### Title: Creates an object of class "ROC" which can be plotted as a ROC
###   curve
### Aliases: ROC ROC,cellHTS-method plot,ROC,missing-method
###   lines,ROC-method
### Keywords: univar

### ** Examples

    data(KcViabSmall)
    x <- normalizePlates(KcViabSmall, scale="multiplicative", log=FALSE, method="median", varianceAdjust="byExperiment")
    x <- scoreReplicates(x, sign="-", method="zscore")
    x <- summarizeReplicates(x, summary="mean")
    y <- ROC(x)
    plot(y)
    lines(y, col="green")
    show(y)



