### Name: Models
### Title: Functions for comparing the tree topologies of two mutagenetic
###   trees mixture models
### Aliases: comp.models comp.models.levels
### Keywords: misc

### ** Examples

## Generate two random RtreemixModel objects each with 3 components.
rand.mod1 <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob =
c(0.2, 0.8))
rand.mod2 <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob =
c(0.2, 0.8))

## Compare the topologies of the tree components of the two randomly
## generated models
comp.models(rand.mod1, rand.mod2)
comp.models.levels(rand.mod1, rand.mod2)



