### Name: cherByThreshold
### Title: Function to identify chers based on thresholds
### Aliases: cherByThreshold
### Keywords: manip

### ** Examples

 ## example with random generated data:
 rpos <- cumsum(round(runif(200)*5))
 rsco <- rnorm(200)+0.2
 plot(rpos, rsco, type="l", col="seagreen3", lwd=2)
 rug(rpos, side=1, lwd=2); abline(h=0, lty=2)              
 rchers <- cherByThreshold(rpos, rsco, threshold=0, distCutOff=2)
 sapply(rchers[-length(rchers)], function(thisClust){
  points(x=as.numeric(names(thisClust)), y=thisClust, type="h", lwd=2,
 col="gold")})



