### Name: sliding.meansd
### Title: Compute mean and standard deviation of scores in a sliding
###   window
### Aliases: sliding.meansd
### Keywords: manip

### ** Examples

   set.seed(123)
   sampleSize <- 10
   ap <- cumsum(1+round(runif(sampleSize)*10))
   as <- c(rnorm(floor(sampleSize/3)),
           rnorm(ceiling(sampleSize/3),mean=1.5),
           rnorm(floor(sampleSize/3)))
   sliding.meansd(ap, as, 20)
   ap
   mean(as[1:3])
   sd(as[1:3])



