### Name: Views-class
### Title: Views objects
### Aliases: class:Views Views-class subject subject,Views-method
###   width<-,Views-method newViews Views views [[,Views-method
###   [[<-,Views-method coerce,Views,NormalIRanges-method
###   restrict,Views-method trim trim,Views-method narrow,Views-method
###   subviews subviews,Views-method gaps,Views-method successiveViews
### Keywords: methods

### ** Examples

  ## Create a set of 4 views on an XInteger subject of length 10:
  subject <- XInteger(10, 3:-6)
  v1 <- Views(subject, start=4:1, end=4:7)

  ## Extract the 2nd view:
  v1[[2]]

  ## 'start' and 'end' are recycled
  Views(subject, 2:1, 4)
  Views(subject, 5:7, )
  Views(subject, , 5:7)

  ## Some views can be "out of limits"
  v2 <- Views(subject, 4:-1, 6)
  trim(v2)
  subviews(v2, end=-2)

  ## gaps() 
  v3 <- Views(subject, start=c(8, 3), end=c(14, 4))
  gaps(v3)

  ## Views on a big XInteger subject:
  subject <- XInteger(99999, sample(99, 99999, replace=TRUE) - 50)
  v4 <- Views(subject, start=1:99*1000, end=1:99*1001)
  v4
  v4[-1]
  v4[[5]]

  ## 31 adjacent views:
  successiveViews(subject, 40:10)



