### Name: RangesList-utils
### Title: RangesList utility functions
### Aliases: RangesList-utils reduce,RangesList-method
###   gaps,RangesList-method
### Keywords: utilities

### ** Examples

  # 'gaps'
  range1 <- IRanges(start=c(1,2,3), end=c(5,2,8))
  range2 <- IRanges(start=c(15,45,20,1), end=c(15,100,80,5))
  collection <- RangesList(one = range1, range2)

  # these two are the same
  RangesList(gaps(range1), gaps(range2))
  gaps(collection)

  # 'reduce'
  range2 <- IRanges(start=c(45,20,1), end=c(100,80,5))
  collection <- RangesList(one = range1, range2)

  # and these two are the same
  reduce(collection)
  RangesList(asNormalIRanges(IRanges(c(1,20), c(8, 100)), force=FALSE))



