### Name: Ranges-class
### Title: Ranges objects
### Aliases: class:Ranges Ranges-class Ranges length,Ranges-method width
###   start,Ranges-method width,Ranges-method end,Ranges-method start<-
###   width<- end<- isEmpty isEmpty,Ranges-method as.matrix,Ranges-method
###   as.data.frame,Ranges-method duplicated,Ranges-method
###   show,Ranges-method [<-,Ranges,ANY,ANY,ANY-method rep,Ranges-method
###   isNormal isNormal,Ranges-method whichFirstNotNormal
###   whichFirstNotNormal,Ranges-method first first,Ranges-method last
###   last,Ranges-method
### Keywords: methods classes

### ** Examples

  x <- IRanges(start=c(2:-1, 13:15), width=c(0:3, 2:0))
  x
  length(x)
  start(x)
  width(x)
  end(x)
  isEmpty(x)
  as.matrix(x)
  as.data.frame(x)

  ## Subsetting:
  x[4:2]                  # 3 ranges
  x[-1]                   # 6 ranges
  x[FALSE]                # 0 range
  x0 <- x[width(x) == 0]  # 2 ranges
  isEmpty(x0)

  ## Use the replacement methods to resize the ranges:
  width(x) <- width(x) * 2 + 1
  x
  end(x) <- start(x)            # equivalent to width(x) <- 0
  x
  width(x) <- c(2, 0, 4) 
  x
  start(x)[3] <- end(x)[3] - 2  # resize the 3rd range
  x
  duplicated(x)

  ## Name the elements:
  names(x)
  names(x) <- c("range1", "range2")
  x
  x[is.na(names(x))]  # 5 ranges
  x[!is.na(names(x))]  # 2 ranges



