### Name: makeWiggleVector
### Title: generate a "wiggle vector" from start/end/value data
### Aliases: makeWiggleVector


### ** Examples

   intervalStarts <- c(3,10,17,22)
   intervalEnds <- c(7,13,20,26)
   values <- c(2, 1.5, .3, 4)
   chrlength <- 30
   wig <- makeWiggleVector( intervalStarts, intervalEnds, values, chrlength )
   # The same effect can be achieved with the following R code, which, however
   # is much slower:
   wig2 <- numeric(chrlength)
   for( i in 1:length(values) )
      wig2[ intervalStarts[i]:intervalEnds[i] ] <- 
         wig2[ intervalStarts[i]:intervalEnds[i] ] + values[i]
   # Let's check that we got the same:
   all( wig == wig2 )      



