### Name: DisplayPars
### Title: DisplayPars constructs objects of type DisplayPars which are
###   used to effect the display of gdObjects
### Aliases: DisplayPars
### Keywords: hplot

### ** Examples

minbase = 10000
maxbase = 15000
mart <- useMart("ensembl", dataset = "scerevisiae_gene_ensembl")
genesplus <- new("GeneRegion", start = minbase, end = maxbase, biomart = mart,
                strand = "+", chromosome = "I", dp = DisplayPars(color =
                "red"))
gaxis <- new("GenomeAxis", add53 = TRUE, add35 = TRUE)
genesminus <- new("GeneRegion", start = minbase, end = maxbase, biomart = mart,
                strand = "-", chromosome = "I", dp = DisplayPars(color =
                "purple", size = 2))
title <- new("Title", title = "genes in a region")
gdPlot(list(genesplus, gaxis, genesminus, title), minbase, maxbase)




