### Name: DisplayPars-class
### Title: Class "DisplayPars" is used to specify graphical parameters to
###   gdObjects.
### Aliases: DisplayPars-class initialize,DisplayPars-method
###   show,DisplayPars-method getPar,DisplayPars-method
###   setPar,DisplayPars-method
### Keywords: classes

### ** Examples

showClass("DisplayPars")

if (interactive()) {
minbase = 10000
maxbase = 15000
mart <- useMart("ensembl", dataset = "scerevisiae_gene_ensembl")
genesplus <- new("GeneRegion", start = minbase, end = maxbase, biomart = mart,
                strand = "+", chromosome = "I", dp = DisplayPars(size = 2))
## plot it. 
gdPlot(list(genesplus, new("Title", title = "genes")), minbase, maxbase)

## to obtain a list of the current graphical parameters:
print(genesplus@dp)

## to set a parameter:
setPar(genesplus, "protein_coding", "pink")
gdPlot(list(genesplus, new("Title", title = "genes")), minbase, maxbase)
}



