### Name: resplot
### Title: Simple Graphical Summaries for Gene Set Enrichment Analysis
###   (GSEA)
### Aliases: resplot restrip mnDiffPlot
### Keywords: methods hplot

### ** Examples


data(sample.ExpressionSet)
lm1 = lmPerGene(sample.ExpressionSet,~sex)
r1 = getResidPerGene(lm1)
### now a boxplot of all residuals by sample
resplot(resmat=exprs(r1),fac=sample.ExpressionSet$sex)
### This plot is not very informative because of some gross outliers;
### try this instead
resplot(resmat=exprs(r1),fac=sample.ExpressionSet$sex,lims=c(-5,5))

### stripchart for first 10 genes
restrip(resmat=exprs(r1)[1:10,],fac=sample.ExpressionSet$type,prefix="Not")

### note the wild trajectory of the loess fit:
mnDiffPlot(exprmat=exprs(sample.ExpressionSet),fac=sample.ExpressionSet$type,xname="Raw Expression",yname="Expression Difference",fitline=TRUE)



