### Name: CollectionType
### Title: Collection Type Class Constructors
### Aliases: CollectionType NullCollection ExpressionSetCollection
###   ComputedCollection KEGGCollection OMIMCollection PfamCollection
###   PrositeCollection PMIDCollection ChrCollection ChrlocCollection
###   MapCollection GOCollection OBOCollection BroadCollection
### Keywords: manip

### ** Examples

NullCollection()

## NullCollection when no collection type specified
collectionType(GeneSet())
collectionType(GeneSet(collectionType=GOCollection()))

## fl could be a url
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gs1 <- getBroadSets(fl)[[1]]
collectionType(gs1) # BroadCollection

## new BroadCollection, with different category
bc <- BroadCollection(category="c2")
## change collectionType of gs2
gs2 <- gs1
collectionType(gs2) <- NullCollection()

## OBOCollection
fl <- system.file("extdata", "goslim_plant.obo", package="GSEABase")
getOBOCollection(fl, evidenceCode="TAS") # returns OBOCollection
OBOCollection(c("GO:0008967", "GO:0015119", "GO:0030372", "GO:0002732",
                "GO:0048090"))



