### Name: gwSnpTests
### Title: methods for iterating association tests (expression vs SNP)
###   across genomes or chromosomes
### Aliases: gwSnpTests residTests
###   residTests,cwSnpScreenResult,smlSet,formula,missing-method
###   gwSnpScreen gwSnpTests,formula,smlSet,cnumOrMissing-method
###   gwSnpTests,formula,smlSet,snpdepth-method
### Keywords: models

### ** Examples

if (!exists("hmceuB36.2021")) data(hmceuB36.2021)
# condense to founders only
hmFou = hmceuB36.2021[, which(hmceuB36.2021$isFounder)]
# show basic formula fit
f1 = gwSnpTests(genesym("CPNE1")~male, hmFou, chrnum(20))
f1
plot(f1)
# show how to avoid adjusted fit
f1b = gwSnpTests(genesym("CPNE1")~1-1, hmFou, chrnum(20))
# show gene set modeling on chromosome
library(GSEABase)
gs1 = GeneSet(c("CPNE1", "ADA"))
geneIdType(gs1) = SymbolIdentifier()
f2 = gwSnpTests(gs1~male, hmFou, chrnum(20))
f2
names(f2)
plot(f2[["ADA"]])
# show 'smlSet-wide' fit
f3 = gwSnpTests(gs1~male, hmFou)
f3



