###################################################
### chunk number 1: 
###################################################
library(DFP)


###################################################
### chunk number 2: 
###################################################
data(rmadataset)
# Number of genes in the test set
length(featureNames(rmadataset))


###################################################
### chunk number 3: 
###################################################
res <- discriminantFuzzyPattern(rmadataset)


###################################################
### chunk number 4: 
###################################################
plotDiscriminantFuzzyPattern(res$discriminant.fuzzy.pattern)


###################################################
### chunk number 5: 
###################################################
library(DFP)


###################################################
### chunk number 6: 
###################################################
dataDir <- system.file("extdata", package="DFP"); dataDir


###################################################
### chunk number 7: 
###################################################
fileExprs <- file.path(dataDir, "exprsData.csv"); fileExprs
filePhenodata <- file.path(dataDir, "pData.csv"); filePhenodata


###################################################
### chunk number 8: 
###################################################
rmadataset <- readCSV(fileExprs, filePhenodata); rmadataset


###################################################
### chunk number 9: 
###################################################
skipFactor <- 3 # Factor to skip odd values
zeta <- 0.5 # Threshold used in the membership functions to label the float values with a discrete value
piVal <- 0.9 # Percentage of values of a class to determine the fuzzy patterns
overlapping <- 2 # Determines the number of discrete labels


###################################################
### chunk number 10: 
###################################################
mfs <- calculateMembershipFunctions(rmadataset, skipFactor); mfs[[1]]
plotMembershipFunctions(rmadataset, mfs, featureNames(rmadataset)[1:2])


###################################################
### chunk number 11: 
###################################################
dvs <- discretizeExpressionValues(rmadataset, mfs, zeta, overlapping); dvs[1:4,1:10]
showDiscreteValues(dvs, featureNames(rmadataset)[1:10],c("healthy", "AML-inv"))


###################################################
### chunk number 12: 
###################################################
fps <- calculateFuzzyPatterns(rmadataset, dvs, piVal, overlapping); fps[1:30,]
showFuzzyPatterns(fps, "healthy")[21:50]


###################################################
### chunk number 13: 
###################################################
dfps <- calculateDiscriminantFuzzyPattern(rmadataset, fps); dfps[1:5,]
plotDiscriminantFuzzyPattern(dfps, overlapping)


###################################################
### chunk number 14: 
###################################################
toLatex(sessionInfo())


