### Name: cghRaw
### Title: Class to contain and describe raw or normalized array
###   comparative genomic hybridization data.
### Aliases: class:cghRaw cghRaw cghRaw-class copynumber,cghRaw-method
###   copynumber<-,cghRaw,matrix-method chromosomes,cghRaw-method
###   bpstart,cghRaw-method bpend,cghRaw-method initialize,cghRaw-method
###   plot.cghRaw,cghRaw,missing-method
### Keywords: classes

### ** Examples

        # create an instance of cghRaw
        new("cghRaw")
        
        # create an instance of cghRaw from a dataframe
        data(WiltingData)
        cghobj <- cghRaw(WiltingData)
        
        # plot the first sample
        plot.cghRaw(cghobj[,1])
        # first three chromosomes
        plot.cghRaw(cghobj[chromosomes(cghobj)==1,1])
        
        # get the copynumber values of the third and fourth sample
        log2ratios <- copynumber(cghobj[,3:4])
        
        # get the names of the samples
        sampleNames(cghobj)
        
        # get the names of the array elements
        featureNames(cghobj)



