### Name: pairwiseAlignment
### Title: Optimal Pairwise Alignment
### Aliases: pairwiseAlignment pairwiseAlignment,character,character-method
###   pairwiseAlignment,character,XString-method
###   pairwiseAlignment,character,XStringSet-method
###   pairwiseAlignment,character,QualityScaledXStringSet-method
###   pairwiseAlignment,XString,character-method
###   pairwiseAlignment,XString,XString-method
###   pairwiseAlignment,XString,XStringSet-method
###   pairwiseAlignment,XString,QualityScaledXStringSet-method
###   pairwiseAlignment,XStringSet,character-method
###   pairwiseAlignment,XStringSet,XString-method
###   pairwiseAlignment,XStringSet,XStringSet-method
###   pairwiseAlignment,XStringSet,QualityScaledXStringSet-method
###   pairwiseAlignment,QualityScaledXStringSet,character-method
###   pairwiseAlignment,QualityScaledXStringSet,XString-method
###   pairwiseAlignment,QualityScaledXStringSet,XStringSet-method
###   pairwiseAlignment,QualityScaledXStringSet,QualityScaledXStringSet-met
###   hod
### Keywords: models methods

### ** Examples

  ## Nucleotide global, local, and overlap alignments
  s1 <- 
    DNAString("ACTTCACCAGCTCCCTGGCGGTAAGTTGATCAAAGGAAACGCAAAGTTTTCAAG")
  s2 <-
    DNAString("GTTTCACTACTTCCTTTCGGGTAAGTAAATATATAAATATATAAAAATATAATTTTCATC")

  # First use a fixed substitution matrix
  mat <- nucleotideSubstitutionMatrix(match = 1, mismatch = -3, baseOnly = TRUE)
  globalAlign <-
    pairwiseAlignment(s1, s2, substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)
  localAlign <-
    pairwiseAlignment(s1, s2, type = "local", substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)
  overlapAlign <-
    pairwiseAlignment(s1, s2, type = "overlap", substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)

  # Then use quality-based method for generating a substitution matrix
  pairwiseAlignment(s1, s2,
                    patternQuality = SolexaQuality(rep(c(22L, 12L), times = c(36, 18))),
                    subjectQuality = SolexaQuality(rep(c(22L, 12L), times = c(40, 20))),
                    scoreOnly = TRUE)

  ## Amino acid global alignment
  pairwiseAlignment(AAString("PAWHEAE"), AAString("HEAGAWGHEE"), substitutionMatrix = "BLOSUM50",
                    gapOpening = 0, gapExtension = -8)



