### Name: injectHardMask
### Title: Injecting a hard mask in a sequence
### Aliases: injectHardMask injectHardMask,XStringViews-method
###   injectHardMask,MaskedXString-method
### Keywords: utilities manip

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. WITH AN XStringViews OBJECT
  ## ---------------------------------------------------------------------
  v2 <- Views("abCDefgHIJK", start=c(8, 3), end=c(14, 4))
  injectHardMask(v2)
  injectHardMask(v2, letter="=")

  ## ---------------------------------------------------------------------
  ## B. WITH A MaskedXString OBJECT
  ## ---------------------------------------------------------------------
  mask0 <- Mask(mask.width=29, start=c(3, 10, 25), width=c(6, 8, 5))
  x <- DNAString("ACACAACTAGATAGNACTNNGAGAGACGC")
  masks(x) <- mask0
  x
  subject <- injectHardMask(x)

  ## Matches can span over masked regions with "hard masking":
  matchPattern("ACggggggA", subject, max.mismatch=6)
  ## but not with "soft masking":
  matchPattern("ACggggggA", x, max.mismatch=6)



