###################################################
### chunk number 1: 
###################################################
require(BicARE)


###################################################
### chunk number 2: 
###################################################
data(sample.bicData)
sample.bicData


###################################################
### chunk number 3: 
###################################################
residue(sample.bicData)  


###################################################
### chunk number 4: 
###################################################
set.seed(1)
res.biclustering <- FLOC(sample.bicData, k=15, pGene=0.3, pSample=0.6, r=0.01, 10, 8, 200)


###################################################
### chunk number 5: 
###################################################
res.biclustering


###################################################
### chunk number 6: 
###################################################
init.genes <- matrix(data=0, nrow=352, ncol=5)
init.samples <- matrix(data=0, nrow=26, ncol=5)
init.genes[1:10,1] <- 1
init.genes[20:30,2] <- 1
init.genes[50:60,3] <- 1
init.samples[1:5,3] <- 1
init.samples[1:5,4] <- 1
init.samples[10:15,5] <- 1


###################################################
### chunk number 7: 
###################################################
bic <- bicluster(res.biclustering, 6, graph=FALSE)
plot(bic)


###################################################
### chunk number 8: 
###################################################
gsc <- GeneSetCollection(res.biclustering$ExpressionSet[1:50], setType=GOCollection())
res.bic2 <- testSet(res.biclustering, gsc)


###################################################
### chunk number 9: 
###################################################
pData(sample.bicData)


###################################################
### chunk number 10: 
###################################################
res.bic2 <- testAnnot(res.biclustering, annot=pData(sample.bicData), covariates=c("sex", "type"))


