###################################################
### chunk number 1: 
###################################################
library(xps)


###################################################
### chunk number 2: 
###################################################
library(xps)


###################################################
### chunk number 3: 
###################################################
celdir <- paste(.path.package("xps"),"raw",sep="/")


###################################################
### chunk number 4: 
###################################################
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))


###################################################
### chunk number 5: 
###################################################
celfiles <- c("TestA1.CEL","TestA2.CEL")
data.test3 <- import.data(scheme.test3, "tmpdt_DataTest3", celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### chunk number 6: 
###################################################
unlist(treeNames(data.test3))


###################################################
### chunk number 7: 
###################################################
celfiles <- c("TestB1.CEL","TestB2.CEL")
data.test3 <- addData(data.test3, celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### chunk number 8: 
###################################################
getTreeNames(rootFile(data.test3))


###################################################
### chunk number 9: 
###################################################
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 10: 
###################################################
data.test3 <- attachInten(data.test3)


###################################################
### chunk number 11: 
###################################################
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 12: 
###################################################
subdata.test3 <- attachInten(data.test3, c("TestB1.cel","TestA2"))
tmp <- intensity(subdata.test3)
head(tmp)


###################################################
### chunk number 13: 
###################################################
data.test3 <- removeInten(data.test3)
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 14: 
###################################################
data.test3 <- attachMask(data.test3)
data.test3 <- attachInten(data.test3)


###################################################
### chunk number 15: hist
###################################################
hist(data.test3)


###################################################
### chunk number 16: boxplot
###################################################
boxplot(data.test3)


###################################################
### chunk number 17: image
###################################################
image(data.test3, names="TestA1.cel_MEAN")


###################################################
### chunk number 18: pmplot
###################################################
pmplot(data.test3)


###################################################
### chunk number 19: 
###################################################
data.test3 <- removeInten(data.test3)
data.test3 <- removeMask(data.test3)


###################################################
### chunk number 20: 
###################################################
library(xps)
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))


###################################################
### chunk number 21: 
###################################################
data.rma <- rma(data.test3, "tmpdt_Test3RMA", verbose=FALSE)


###################################################
### chunk number 22: 
###################################################
data.mas5 <- mas5(data.test3, "tmpdt_Test3MAS5", normalize=TRUE, sc=500, update=TRUE, verbose=FALSE)


###################################################
### chunk number 23: 
###################################################
expr.rma <- validData(data.rma)
expr.mas5 <- validData(data.mas5)


###################################################
### chunk number 24: plot
###################################################
plot(expr.rma[,1],expr.mas5[,1],log="xy",xlim=c(1,20000),ylim=c(1,20000))


###################################################
### chunk number 25: 
###################################################
call.mas5 <- mas5.call(data.test3,"tmpdt_Test3Call", verbose=FALSE)


###################################################
### chunk number 26: 
###################################################
call.dabg <- dabg.call(data.test3,"tmpdt_Test3DABG", verbose=FALSE)


###################################################
### chunk number 27: 
###################################################
pres.mas5 <- presCall(call.mas5)
head(pres.mas5)


###################################################
### chunk number 28: 
###################################################
pval.mas5 <- pvalData(call.mas5)
head(pval.mas5)


###################################################
### chunk number 29: hist-rma
###################################################
hist(data.rma)


###################################################
### chunk number 30: boxplot-rma
###################################################
boxplot(data.rma)


###################################################
### chunk number 31: mvaplot
###################################################
mvaplot(data.rma, pch=20, ylim=c(-2,2), names="TestB1.mdp_LEVEL")


###################################################
### chunk number 32: callplot
###################################################
callplot(call.mas5)


###################################################
### chunk number 33: 
###################################################
getTreeNames(rootFile(data.mas5))


###################################################
### chunk number 34: 
###################################################
bgrd <- export.root(rootFile(data.mas5),schemeFile(data.mas5),"PreprocesSet","TestA2","wbg","fBg","BgrdROOTOut.txt",as.dataframe=TRUE, verbose=FALSE)


###################################################
### chunk number 35: 
###################################################
wbg <- matrix(bgrd[,"BGRD"], ncol=ncols(schemeSet(data.mas5)), nrow=nrows(schemeSet(data.mas5)))


###################################################
### chunk number 36: image-bg
###################################################
image(log2(wbg))


###################################################
### chunk number 37: 
###################################################
prefltr <- PreFilter(mad=c(0.5), lothreshold=c(7.0,0.02,"mean"), hithreshold=c(10.5,80.0,"percent"))
str(prefltr)


###################################################
### chunk number 38: 
###################################################
data.rma@rootfile <- paste(.path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(.path.package("xps"),"rootdata",sep="/")


###################################################
### chunk number 39: 
###################################################
rma.pfr <- prefilter(data.rma, "tmpdt_Test3Prefilter", getwd(),
                     filter=prefltr, minfilters=2, verbose=FALSE)


###################################################
### chunk number 40: 
###################################################
tmp <- validData(rma.pfr)
head(tmp)
dim(tmp[tmp[,"FLAG"]==1,])


###################################################
### chunk number 41: 
###################################################
unifltr <- UniFilter(foldchange=c(1.3,"both"), unifilter=c(0.1,"pval"))


###################################################
### chunk number 42: 
###################################################
data.rma@rootfile <- paste(.path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(.path.package("xps"),"rootdata",sep="/")


###################################################
### chunk number 43: 
###################################################
rma.ufr <- unifilter(data.rma, "tmpdt_Test3Unifilter", getwd(),
                     unifltr, group=c("GrpA","GrpA","GrpB","GrpB"),
                     xps.fltr=rma.pfr, verbose=FALSE)


###################################################
### chunk number 44: 
###################################################
tmp <- validData(rma.ufr)
tmp


###################################################
### chunk number 45: 
###################################################
msk <- validFilter(rma.ufr)
tmp <- validData(rma.ufr, which="UnitName")
tmp <- cbind(tmp, msk)


###################################################
### chunk number 46: 
###################################################
tmp <- export.filter(rma.ufr, treetype="stt",
                     varlist="fUnitName:fName:fSymbol:fc:pval:flag",
                     as.dataframe=T, verbose=FALSE)
head(tmp)


###################################################
### chunk number 47: volcanoplot
###################################################
volcanoplot(rma.ufr, labels="fSymbol")


###################################################
### chunk number 48:  eval=FALSE
###################################################
## library(xps)
## libdir <- "/path/to/Affy/libraryfiles"
## anndir <- "/path/to/Affy/Annotation"
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"


###################################################
### chunk number 49:  eval=FALSE
###################################################
## scheme.test3 <- import.expr.scheme("Scheme_Test3_na25", 
##                        filedir=scmdir,  
##                        paste(libdir,"Test3.CDF",sep="/"), 
##                        paste(libdir,"Test3_probe.tab",sep="/"), 
##                        paste(anndir,"Test3.na25.annot.csv",sep="/"))


###################################################
### chunk number 50:  eval=FALSE
###################################################
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"
## scheme.test3 <- root.scheme(paste(scmdir,"SchemeTest3.root",sep="/"))


###################################################
### chunk number 51:  eval=FALSE
###################################################
## scheme.test3 <- import.expr.scheme("Scheme_Test3_na25",..., add.mask=TRUE)


###################################################
### chunk number 52:  eval=FALSE
###################################################
## library(Biobase)
## expr.rma <- validData(data.rma)
## minimalSet <- new("ExpressionSet", exprs = as.matrix(expr.rma))


###################################################
### chunk number 53:  eval=FALSE
###################################################
## vv <- minimalSet[1:5,1:3]
## featureNames(vv)
## sampleNames(vv)
## exprs(vv)


###################################################
### chunk number 54:  eval=FALSE
###################################################
## root.image(data.exon, treename="BreastA.cel", w=400, h=400)


###################################################
### chunk number 55:  eval=FALSE
###################################################
## root.density(data.exon, "*", w=400, h=400)
## root.density(data.x.rma, "*", w=400, h=400)


###################################################
### chunk number 56:  eval=FALSE
###################################################
## root.graph2D(data.exon, "BreastA.cel", "BreastB.cel")
## root.graph2D(data.x.rma, "BreastA.mdp", "BreastB.mdp")


###################################################
### chunk number 57:  eval=FALSE
###################################################
## root.hist2D(data.exon, "BreastA.cel", "BreastB.cel", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="SURF2")


###################################################
### chunk number 58:  eval=FALSE
###################################################
## root.hist3D(data.exon, "BreastA.cel", "BreastB.cel", "BreastC.cel", option="SCAT")
## root.hist3D(data.x.rma, "BreastA.mdp", "BreastB.mdp", "BreastC.mdp", option="SCAT")


