###################################################
### chunk number 1: LibraryPreload
###################################################
library(multtest)
library(xcms)
library(faahKO)


###################################################
### chunk number 2: RawFiles
###################################################
cdfpath <- system.file("cdf", package = "faahKO")
list.files(cdfpath, recursive = TRUE)


###################################################
### chunk number 3: PeakIdentification
###################################################
library(xcms)
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
xset <- xcmsSet(cdffiles)
#xset <- faahko
xset


###################################################
### chunk number 4: PeakMatching1
###################################################
xset <- group(xset)


###################################################
### chunk number 5: RTCorrection
###################################################
xset2 <- retcor(xset, family = "symmetric", plottype = "mdevden")


###################################################
### chunk number 6: PeakMatching2
###################################################
xset2 <- group(xset2, bw = 10)


###################################################
### chunk number 7: PeakFillIn
###################################################
xset3 <- fillPeaks(xset2)
xset3


###################################################
### chunk number 8: AnalysisVisualize
###################################################
reporttab <- diffreport(xset3, "WT", "KO", "example", 10, 
                        metlin = 0.15)
reporttab[1:4,]


###################################################
### chunk number 9: URL1
###################################################
cat("\\url{", as.character(reporttab[1,"metlin"]), "}", sep = "")


###################################################
### chunk number 10: URL2
###################################################
cat("\\url{", as.character(reporttab[3,"metlin"]), "}", sep = "")


###################################################
### chunk number 11: PeakSelect
###################################################
gt <- groups(xset3)
colnames(gt)
groupidx1 <- which(gt[,"rtmed"] > 2600 & gt[,"rtmed"] < 2700 & gt[,"npeaks"] == 12)[1]
groupidx2 <- which(gt[,"rtmed"] > 3600 & gt[,"rtmed"] < 3700 & gt[,"npeaks"] == 12)[1]
eiccor <- getEIC(xset3, groupidx = c(groupidx1, groupidx2))
eicraw <- getEIC(xset3, groupidx = c(groupidx1, groupidx2), rt = "raw")


###################################################
### chunk number 12: EICRaw1
###################################################
plot(eicraw, xset3, groupidx = 1)


###################################################
### chunk number 13: EICRaw2
###################################################
plot(eicraw, xset3, groupidx = 2)


###################################################
### chunk number 14: EICCor1
###################################################
plot(eiccor, xset3, groupidx = 1)


###################################################
### chunk number 15: EICCor2
###################################################
plot(eiccor, xset3, groupidx = 2)


