### Name: stam.fit
### Title: Fit StAM Model to Training Data
### Aliases: stam.fit
### Keywords: classif

### ** Examples

## Not run: 
##D # prepare data
##D library(golubEsets)
##D data(Golub_Merge)
##D 
##D # load and prepare some data
##D golubTrain <- Golub_Merge[,1:38]
##D data(golubTrain.cv)
##D 
##D # compute fit
##D golubTrain.fit <- stam.fit(golubTrain.cv, golubTrain, alpha=seq(0, 1, 0.1))
##D 
##D # investigate
##D print(golubTrain.fit)
##D plot(golubTrain.fit)
## End(Not run)

# show clickable web-page
## Not run: 
##D map <- stam.graph.plot(golubTrain.fit, outfile="golubTrain")
##D cat("<HTML><BODY><MAP NAME='graph_map'>", map, "</MAP>",
##D     "<IMG SRC='golubTrain_graph_plot.png' USEMAP='#graph_map'></BODY></HTML>\n", 
##D     file="graph_plot.html")
##D browseURL(paste("file://", getwd(), "/graph_plot.html", sep=""))
## End(Not run)


