###################################################
### chunk number 1: 
###################################################
library(sigPathway)
data(MuscleExample)
ls()



###################################################
### chunk number 2: 
###################################################
dim(tab)
print(tab[501:504, 1:3])
table(phenotype)



###################################################
### chunk number 3: PSIDhist
###################################################
statList <- calcTStatFast(tab, phenotype, ngroups = 2)
hist(statList$pval, breaks = seq(0,1,0.025), xlab = "p-value",
     ylab = "Frequency", main = "")


###################################################
### chunk number 4: 
###################################################
set.seed(1234)
res.muscle <-
  runSigPathway(G, 20, 500, tab, phenotype, nsim = 1000,
                weightType = "constant", ngroups = 2, npath = 25, 
                verbose = FALSE, allpathways = FALSE, annotpkg = "hgu133a",
                alwaysUseRandomPerm = FALSE)


###################################################
### chunk number 5: 
###################################################
print(res.muscle$df.pathways[1:10, ])


###################################################
### chunk number 6: 
###################################################
print(res.muscle$list.gPS[[7]][1:10, ])


###################################################
### chunk number 7: 
###################################################
print(sessionInfo())


