### Name: SBMLDocument-class
### Title: "SBMLDocument" from libsbml
### Aliases: SBMLDocument-class coerce,SBMLDocument,graph-method
###   coerce,SBMLDocument,SBML-method rsbml_check,SBMLDocument-method
###   rsbml_check rsbml_dom,SBMLDocument-method rsbml_dom
###   rsbml_graph,SBMLDocument-method rsbml_graph
###   rsbml_problems,SBMLDocument-method rsbml_problems
###   rsbml_write,SBMLDocument-method rsbml_xml,SBMLDocument-method
###   as.character.SBMLDocument
### Keywords: classes

### ** Examples

  # Read a document
  doc <- rsbml_read(system.file("sbml", "GlycolysisLayout.xml", package = "rsbml"))
  
  # Check the document
  rsbml_check(doc)
  
  # Convert it to an S4 DOM
  dom <- rsbml_dom(doc)
  
  # Or a graph
  graph <- rsbml_graph(doc)
  
  # Write it out to a file
  ## Not run: rsbml_write(doc, "my.xml")
  
  # Or convert it to a string of XML
  rsbml_xml(doc)



