### Name: SBML-class
### Title: SBML type "SBML"
### Aliases: SBML-class coerce,SBML,SBMLDocument-method coerce
###   level,SBML-method level level<-,SBML-method level<- model,SBML-method
###   model model<-,SBML-method model<- rsbml_doc,SBML-method rsbml_doc
###   rsbml_write,SBML-method rsbml_write rsbml_xml,SBML-method rsbml_xml
###   ver,SBML-method ver ver<-,SBML-method ver<- as.character.SBML
### Keywords: classes

### ** Examples

  # Get a DOM
  doc <- rsbml_read(system.file("sbml", "GlycolysisLayout.xml", package = "rsbml"))
  dom <- rsbml_dom(doc)
  
  # Get the species ID's
  sapply(species(model(dom)), id)
  
  # Convert DOM back to a low-level document for checking
  doc <- rsbml_doc(dom)
  rsbml_check(doc)
  
  # Write a DOM to a file
  ## Not run: rsbml_write(dom, "my.xml")



