### Name: plgem.obsStn
### Title: Computation of Observed and Resampled PLGEM-STN statistics
### Aliases: plgem.obsStn plgem.resampledStn
### Keywords: models

### ** Examples

  data(LPSeset)
  LPSfit <- plgem.fit(data=LPSeset)
  LPSobsStn <- plgem.obsStn(data=LPSeset, plgemFit=LPSfit)
  set.seed(123)
  LPSresampledStn <- plgem.resampledStn(data=LPSeset, plgemFit=LPSfit)
  plot(density(LPSresampledStn[["RESAMPLED.STN"]], bw=0.01), col="black", lwd=2,
    xlab="PLGEM STN values",
    main="Distribution of observed and resampled PLGEM STN values")
  lines(density(LPSobsStn, bw=0.01), col="red")
  legend("topright", legend=c("resampled", "observed"), col=c("black", "red"),
    lwd=2:1)



