### Name: corplot
### Title: Produce a plot for jointly visualizing pooled correlation
###   information and expression data for selected genes
### Aliases: corplot
### Keywords: hplot iplot

### ** Examples

library(multtest)
library(hu6800)  
data(golub)
rownames(golub) <- golub.gnames[,3]
colnames(golub) <- golub.cl
KEGG.list <- as.list(hu6800PATH)
imat <- getImat(golub, KEGG.list, ms=10) 
colnames(imat) <- paste("KEGG", colnames(imat), sep="")
sel <- c("04620","04120")
main <- paste("KEGG", sel, sep="")
for(i in 1:length(sel)){
fname <- paste("corplot-KEGG",sel[i] , ".jpg", sep="")
jpeg(fname, width=1600, height=1200, quality=100)
selgene <- rownames(imat)[imat[,match(paste("KEGG",sel,sep="")[i],colnames(imat))]==1]
corplot(golub, selgene, golub.cl, main=main[i])
dev.off()
}



