### Name: nlpca
### Title: Non-linear PCA
### Aliases: nlpca
### Keywords: multivariate

### ** Examples

# Data set with three variables where data points constitute a helix
data(helix)
helixNA <- helix
helixNA <- t(apply(helix, 1, function(x) { x[sample(1:3, 1)] <- NA; x})) # not a single complete observation
helixNlPca <- pca(helixNA, nPcs=1, method="nlpca", maxSteps=1000)
fittedData <- fitted(helixNlPca, helixNA)
plot(fittedData[which(is.na(helixNA))], helix[which(is.na(helixNA))])
# compared to solution by Nipals PCA that cannot extract non-linear patterns
helixNipPca <- pca(helixNA, nPcs=2, method="nipals")
fittedData <- fitted(helixNipPca)
plot(fittedData[which(is.na(helixNA))], helix[which(is.na(helixNA))])



