/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.geese.rShell;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.gaggle.core.Boss;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.core.datatypes.Cluster;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.core.datatypes.GaggleTuple;
import org.systemsbiology.gaggle.core.datatypes.Interaction;
import org.systemsbiology.gaggle.core.datatypes.Namelist;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.systemsbiology.gaggle.core.datatypes.Single;
import org.systemsbiology.gaggle.core.datatypes.Tuple;
import org.systemsbiology.gaggle.geese.common.GaggleConnectionListener;
import org.systemsbiology.gaggle.geese.common.GooseShutdownHook;
import org.systemsbiology.gaggle.geese.common.RmiGaggleConnector;
import org.systemsbiology.gaggle.geese.rShell.StringToObjectConverter;

public class RShellGoose
implements Goose,
GaggleConnectionListener {
    String myGaggleName = "R";
    Boss gaggleBoss;
    RmiGaggleConnector connector = new RmiGaggleConnector(this);
    String gaggleBossHostName = "localhost";
    static RShellGoose self;
    boolean verbose = false;
    String[] activeGeeseNames = new String[0];
    String[] nameList = new String[0];
    DataMatrix matrix = null;
    Network network = null;
    GaggleTuple gaggleTuple = null;
    String clusterName = null;
    String[] clusterRowNames = null;
    String[] clusterColumnNames = null;
    String defaultSpecies = "Homo sapiens";
    String targetGoose = "all";
    Map<String, String> networkMetadata = new HashMap<String, String>();

    public RShellGoose() {
        this("localhost", false);
    }

    public RShellGoose(boolean verbose) {
        this("localhost", verbose);
    }

    public RShellGoose(String gaggleBossHostName) {
        this(gaggleBossHostName, false);
    }

    public RShellGoose(String gaggleBossHostName, boolean verbose) {
        new GooseShutdownHook(this.connector);
        self = this;
        this.gaggleBossHostName = gaggleBossHostName;
        this.verbose = verbose;
        try {
            this.connectToGaggle();
        }
        catch (Exception ex0) {
            System.err.println("RShellGoose failed to export remote object: " + ex0.getMessage());
        }
    }

    public String getVersion() {
        String id = "$Revision: 2680 $";
        String signature = "Revision: ";
        int start = id.indexOf(signature);
        int end = id.indexOf(" $", start += signature.length());
        return id.substring(start, end);
    }

    public void connectToGaggle() {
        block2: {
            try {
                this.connector.connectToGaggle(this.gaggleBossHostName);
                System.out.println("Connected to gaggle with goose name " + this.getName());
                System.out.println("Use the disconnectFromGaggle() method to disconnect.");
            }
            catch (Exception ex0) {
                System.err.println("\n\n\tFailed to connect to Gaggle Boss:\n\t\t" + ex0.getMessage());
                System.err.println("\n\tPossible causes: ");
                System.err.println("\t\t1) There is no Gaggle Boss running.");
                System.err.println("\t\t2) You are using an out-of-date Gaggle Boss.");
                System.err.println("\t\t3) Hang on a sec, a boss is probably autostarting now;");
                System.err.println("\t\t\t(Wait a few moments and give the showGoose('boss') command.)");
                if (!this.verbose || this.connector.getAutoStartBoss()) break block2;
                ex0.printStackTrace();
            }
        }
        this.gaggleBoss = this.connector.getBoss();
    }

    public static RShellGoose getCurrent() {
        return self;
    }

    public String[] getNameList() {
        if (this.nameList.length == 0) {
            System.out.println("The R goose has not received a namelist broadcast.");
        }
        return this.nameList;
    }

    public void handleNameList(String source, Namelist nameList) {
        System.out.println("nameList ready, length " + nameList.getNames().length);
        this.defaultSpecies = nameList.getSpecies();
        this.nameList = nameList.getNames();
    }

    public void handleMatrix(String source, DataMatrix matrix) {
        this.matrix = matrix;
        System.out.println("matrix ready, dimension " + this.matrix.getRowCount() + " x " + this.matrix.getColumnCount());
        this.defaultSpecies = matrix.getSpecies();
    }

    public int getMatrixRowCount() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.getRowCount();
    }

    public int getMatrixColumnCount() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.getColumnCount();
    }

    public String[] getMatrixRowNames() {
        if (this.matrix == null) {
            return new String[0];
        }
        return this.matrix.getRowTitles();
    }

    public String[] getMatrixColumnNames() {
        if (this.matrix == null) {
            return new String[0];
        }
        return this.matrix.getColumnTitles();
    }

    public double[] getMatrixRow(int rowNumber) {
        if (this.matrix == null) {
            return new double[0];
        }
        return this.matrix.get(rowNumber);
    }

    public double[] getAllMatrixData() {
        if (this.matrix == null) {
            System.out.println("The R goose has not received a matrix broadcast.");
            return new double[0];
        }
        int rowCount = this.matrix.getRowCount();
        int columnCount = this.matrix.getColumnCount();
        int total = rowCount * columnCount;
        double[] result = new double[total];
        for (int r = 0; r < rowCount; ++r) {
            double[] rowValues = this.matrix.get(r);
            int toPosition = r * columnCount;
            System.arraycopy(rowValues, 0, result, toPosition, columnCount);
        }
        return result;
    }

    public void test(String name) {
        System.out.println("RShellGoose test (String name): " + name);
    }

    public void test(String[] names) {
        System.out.println("RShellGoose test (String [] name): " + names.length);
    }

    public void test(int i) {
        System.out.println("RShellGoose test (int i): " + i);
    }

    public void test(int[] i) {
        System.out.println("RShellGoose test (int i []): " + i.length);
    }

    public void test(Integer i) {
        System.out.println("RShellGoose test (Integer i): " + i);
    }

    public void test(Integer[] i) {
        System.out.println("RShellGoose test (Integer [] i): " + i.length);
    }

    public void test(double d) {
        System.out.println("RShellGoose test (double d): " + d);
    }

    public void test(Double d) {
        System.out.println("RShellGoose test (Double d: " + d);
    }

    public void test(double[] numbers) {
        System.out.println("RShellGoose test (double [] numbers): " + numbers.length);
    }

    public void test(Double[] numbers) {
        System.out.println("RShellGoose test (Double [] numbers): " + numbers.length);
    }

    public HashMap convertGaggleTupleToHashMap(GaggleTuple gaggleTuple) {
        return null;
    }

    public GaggleTuple convertHashMapToGaggleTuple(HashMap map) {
        return null;
    }

    public void createAndBroadcastDoubleAttributes(String attributeName, String[] names, double[] values) {
        Serializable[] doubles = new Double[values.length];
        for (int i = 0; i <= values.length; ++i) {
            doubles[i] = Double.valueOf(values[i]);
        }
        GaggleTuple gt = this.createGaggleTupleForBroadcast(attributeName, names, doubles);
        this.broadcastAssociativeArray(gt);
    }

    public void createAndBroadcastGaggleTuple(String title, String attributeName, String allNames, String[] allValues) {
        String[] allNamesArray = new String[]{allNames};
        this.createAndBroadcastGaggleTuple(title, attributeName, allNamesArray, allValues);
    }

    public void createAndBroadcastGaggleTuple(String title, String attributeName, String[] allNames, String allValues) {
        String[] allValuesArray = new String[]{allValues};
        this.createAndBroadcastGaggleTuple(title, attributeName, allNames, allValuesArray);
    }

    public void createAndBroadcastGaggleTuple(String title, String attributeName, String allNames, String allValues) {
        String[] allNamesArray = new String[]{allNames};
        String[] allValuesArray = new String[]{allValues};
        this.createAndBroadcastGaggleTuple(title, attributeName, allNamesArray, allValuesArray);
    }

    protected Class getValueType(String[] allValues) {
        boolean foundDouble = false;
        for (String value : allValues) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                try {
                    Double.valueOf(value);
                    foundDouble = true;
                }
                catch (NumberFormatException e1) {
                    return String.class;
                }
            }
        }
        if (foundDouble) {
            return Double.class;
        }
        return Integer.class;
    }

    public void createAndBroadcastGaggleTuple(String title, String attributeName, String[] allNames, String[] allValues) {
        Class valueClass = this.getValueType(allValues);
        GaggleTuple gaggleTuple = new GaggleTuple();
        gaggleTuple.setName(title);
        Tuple metadata = new Tuple();
        metadata.addSingle(new Single((Serializable)((Object)title)));
        gaggleTuple.setMetadata(metadata);
        Tuple dataTuple = new Tuple();
        dataTuple.setName(title);
        gaggleTuple.setSpecies(this.defaultSpecies);
        for (int i = 0; i < allNames.length; ++i) {
            String s;
            Object value = valueClass.equals(Integer.class) ? Integer.valueOf(allValues[i]) : (valueClass.equals(Double.class) ? Double.valueOf(allValues[i]) : ((s = allValues[i]).startsWith("|") && s.endsWith("|") ? s.substring(1, s.length() - 1) : allValues[i]));
            Tuple row = new Tuple();
            row.addSingle(new Single((Serializable)((Object)allNames[i])));
            row.addSingle(new Single((Serializable)((Object)attributeName)));
            row.addSingle(new Single((Serializable)value));
            dataTuple.addSingle(new Single(row));
        }
        gaggleTuple.setData(dataTuple);
        try {
            this.gaggleBoss.broadcastTuple(this.myGaggleName, this.targetGoose, gaggleTuple);
        }
        catch (RemoteException e) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            e.printStackTrace();
        }
    }

    protected GaggleTuple createGaggleTupleForBroadcast(String tupleName, String[] names, Serializable[] values) {
        Tuple tuple = new Tuple();
        for (int i = 0; i < names.length; ++i) {
            tuple.addSingle(new Single(names[i], values[i]));
        }
        GaggleTuple gaggleTuple = new GaggleTuple();
        gaggleTuple.setName(tupleName);
        gaggleTuple.setData(tuple);
        gaggleTuple.setSpecies(this.defaultSpecies);
        return gaggleTuple;
    }

    public String getTupleAttributeName() {
        if (this.gaggleTuple == null) {
            System.out.println("The R Goose has not received a Tuple broadcast.");
            return "";
        }
        return (String)((Object)this.gaggleTuple.getMetadata().getSingleAt(0).getValue());
    }

    public String getTupleTitle() {
        if (this.gaggleTuple == null) {
            System.out.println("The R Goose has not received a Tuple broadcast.");
            return "";
        }
        return this.gaggleTuple.getName();
    }

    public String[] getTupleKeys() {
        if (this.gaggleTuple == null) {
            System.out.println("The R Goose has not received a Tuple broadcast.");
            return new String[0];
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < this.gaggleTuple.getData().getSingleList().size(); ++i) {
            Tuple tuple = (Tuple)this.gaggleTuple.getData().getSingleAt(i).getValue();
            keys.add((String)((Object)tuple.getSingleAt(0).getValue()));
        }
        return keys.toArray(new String[0]);
    }

    public String[] getTupleValues() {
        if (this.gaggleTuple == null) {
            System.out.println("The R Goose has not received a Tuple broadcast.");
            return new String[0];
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.gaggleTuple.getData().getSingleList().size(); ++i) {
            Tuple tuple = (Tuple)this.gaggleTuple.getData().getSingleAt(i).getValue();
            String str = (String)((Object)tuple.getSingleAt(2).getValue());
            values.add(str);
        }
        return values.toArray(new String[0]);
    }

    public void createAndBroadcastIntegerAttributes(String attributeName, String[] names, int[] values) {
        Serializable[] integers = new Integer[values.length];
        for (int i = 0; i <= values.length; ++i) {
            integers[i] = Integer.valueOf(values[i]);
        }
        this.broadcastAssociativeArray(this.createGaggleTupleForBroadcast(attributeName, names, integers));
    }

    public void createAndBroadcastStringAtrributes(String attributeName, String[] names, String[] values) {
        this.broadcastAssociativeArray(this.createGaggleTupleForBroadcast(attributeName, names, (Serializable[])values));
    }

    public void createAndBroadcastHashMap(String title, String attributeName, String name, String value) {
        String[] names = new String[]{name};
        String[] values = new String[]{value};
        this.createAndBroadcastHashMap(title, attributeName, names, values);
    }

    public void createAndBroadcastHashMap(String title, String attributeName, String name, double value) {
        String[] names = new String[]{name};
        double[] values = new double[]{value};
        this.createAndBroadcastHashMap(title, attributeName, names, values);
    }

    public void createAndBroadcastHashMap(String title, String attributeName, String[] names, String[] values) {
        try {
            this.gaggleBoss.broadcastTuple(this.myGaggleName, this.targetGoose, this.createGaggleTupleForBroadcast(title, names, (Serializable[])values));
        }
        catch (RemoteException rex) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
            rex.printStackTrace();
        }
    }

    public void createAndBroadcastHashMap(String title, String attributeName, String[] names, double[] values) {
        GaggleTuple gaggleTuple = new GaggleTuple();
        gaggleTuple.setName(title);
        Tuple tuple = new Tuple(title);
        for (int i = 0; i <= names.length; ++i) {
            tuple.addSingle(new Single(names[i], Double.valueOf(values[i])));
        }
        gaggleTuple.setData(tuple);
        gaggleTuple.setSpecies(this.defaultSpecies);
        try {
            this.gaggleBoss.broadcastTuple(this.myGaggleName, this.targetGoose, gaggleTuple);
        }
        catch (RemoteException rex) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
            rex.printStackTrace();
        }
    }

    public void createAndBroadcastMatrix(String[] rowNames, String[] columnNames, double[] data, String matrixName) {
        DataMatrix matrix = new DataMatrix();
        int rowCount = rowNames.length;
        int columnCount = columnNames.length;
        matrix.setSize(rowCount, columnCount);
        if (matrixName != null) {
            matrix.setName(matrixName);
        }
        matrix.setRowTitles(rowNames);
        matrix.setColumnTitles(columnNames);
        for (int r = 0; r < rowCount; ++r) {
            double[] rowValues = new double[columnCount];
            int fromPosition = r * columnCount;
            System.arraycopy(data, fromPosition, rowValues, 0, columnCount);
            matrix.set(r, rowValues);
        }
        this.broadcastMatrix(matrix);
    }

    protected String[] networkToStringArray(Network network) {
        String[] orphanNodes;
        Interaction[] interactions = network.getInteractions();
        ArrayList<String> list = new ArrayList<String>();
        for (Interaction interaction : interactions) {
            String source = interaction.getSource();
            String target = interaction.getTarget();
            String type = interaction.getType();
            String combined = source + "::" + target + "::" + type;
            list.add(combined);
        }
        for (String orphanNode : orphanNodes = network.getOrphanNodes()) {
            list.add(orphanNode);
        }
        return list.toArray(new String[0]);
    }

    protected String[] networkEdgeAttributesToStringArray(Network network) {
        Interaction[] interactions = network.getInteractions();
        String[] attributeNames = network.getEdgeAttributeNames();
        ArrayList<String> list = new ArrayList<String>();
        for (Interaction interaction : interactions) {
            String source = interaction.getSource();
            String type = interaction.getType();
            String target = interaction.getTarget();
            String edgeName = source + " (" + type + ") " + target;
            String terseEdgeName = source + "::" + target + "::" + type;
            for (String name : attributeNames) {
                HashMap hash = network.getEdgeAttributes(name);
                if (hash.containsKey(edgeName)) {
                    Object value = hash.get(edgeName);
                    StringBuffer sb = new StringBuffer();
                    sb.append(terseEdgeName);
                    sb.append("::");
                    sb.append(name);
                    sb.append("::");
                    sb.append(value.toString());
                    list.add(sb.toString());
                    continue;
                }
                System.out.println("no " + name + " attribute for " + edgeName);
            }
        }
        return list.toArray(new String[0]);
    }

    protected String[] networkNodeAttributesToStringArray(Network network) {
        String[] attributeNames = network.getNodeAttributeNames();
        ArrayList<String> list = new ArrayList<String>();
        for (String attributeName : attributeNames) {
            String[] nodeNames;
            HashMap attributeHash = network.getNodeAttributes(attributeName);
            for (String nodeName : nodeNames = attributeHash.keySet().toArray(new String[0])) {
                Object value = attributeHash.get(nodeName);
                String terseForm = nodeName + "::" + attributeName + "::" + value.toString();
                list.add(terseForm);
            }
        }
        return list.toArray(new String[0]);
    }

    public String[] getNetworkAsStringArray() {
        String[] result = new String[]{};
        if (this.network != null) {
            result = this.networkToStringArray(this.network);
        } else {
            System.out.println("The R goose has not received a network broadcast.");
        }
        return result;
    }

    public String[] getNetworkEdgeAttributesAsStringArray() {
        String[] result = new String[]{};
        if (this.network != null) {
            result = this.networkEdgeAttributesToStringArray(this.network);
        }
        return result;
    }

    public String[] getNetworkNodeAttributesAsStringArray() {
        String[] result = new String[]{};
        if (this.network != null) {
            result = this.networkNodeAttributesToStringArray(this.network);
        }
        return result;
    }

    public void createAndBroadcastNetwork(String[] interactionStrings, String[] nodeAttributeStrings, String[] edgeAttributeStrings, String name) {
        String[] tokens;
        Network network = new Network();
        this.addMetaDataToNetwork(network);
        network.setName(name);
        network.setSpecies(this.defaultSpecies);
        for (String interactionString : interactionStrings) {
            tokens = interactionString.split("::");
            int tokenCount = tokens.length;
            if (tokenCount == 1 && tokens[0].trim().length() > 0) {
                network.add(tokens[0]);
                continue;
            }
            if (tokenCount != 3) continue;
            String sourceNode = tokens[0];
            String targetNode = tokens[1];
            String interactionType = tokens[2];
            network.add(new Interaction(sourceNode, targetNode, interactionType));
        }
        for (String nodeAttributeString : nodeAttributeStrings) {
            tokens = nodeAttributeString.split("::");
            if (tokens.length != 3) continue;
            String nodeName = tokens[0].trim();
            String attributeName = tokens[1].trim();
            String rawValue = tokens[2].trim();
            Object value = StringToObjectConverter.convert(rawValue);
            network.addNodeAttribute(nodeName, attributeName, value);
        }
        for (String edgeAttributeString : edgeAttributeStrings) {
            tokens = edgeAttributeString.split("::");
            if (tokens.length != 5) continue;
            String sourceNode = tokens[0].trim();
            String targetNode = tokens[1].trim();
            String edgeType = tokens[2].trim();
            String attributeName = tokens[3].trim();
            String rawValue = tokens[4].trim();
            Object value = StringToObjectConverter.convert(rawValue);
            String edgeName = sourceNode + " (" + edgeType + ") " + targetNode;
            network.addEdgeAttribute(edgeName, attributeName, value);
        }
        try {
            this.gaggleBoss.broadcastNetwork(this.myGaggleName, this.targetGoose, network);
        }
        catch (RemoteException rex) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            rex.printStackTrace();
        }
    }

    public void createAndBroadcastNetwork(String sourceNode, String[] targetNodes, double[] weights, String[] targetTypes) {
        Network network = new Network();
        this.addMetaDataToNetwork(network);
        network.setSpecies(this.defaultSpecies);
        for (int i = 0; i < targetNodes.length; ++i) {
            Interaction interaction = new Interaction(sourceNode, targetNodes[i], targetTypes[i]);
            network.add(interaction);
            String edgeName = sourceNode + " (" + targetTypes[i] + ") " + targetNodes[i];
            network.addEdgeAttribute(edgeName, "weight", weights[i]);
        }
        try {
            this.gaggleBoss.broadcastNetwork(this.myGaggleName, this.targetGoose, network);
        }
        catch (RemoteException rex) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            rex.printStackTrace();
        }
    }

    protected void addMetaDataToNetwork(Network network) {
        if (this.networkMetadata.size() == 0) {
            return;
        }
        Tuple metadata = new Tuple();
        Set<String> keys = this.networkMetadata.keySet();
        for (String key : keys) {
            metadata.addSingle(new Single(key, (Serializable)((Object)this.networkMetadata.get(key))));
        }
        network.setMetadata(metadata);
    }

    public void handleTuple(String source, GaggleTuple gaggleTuple) {
        this.gaggleTuple = gaggleTuple;
        this.defaultSpecies = gaggleTuple.getSpecies();
        System.out.println("received tuple broadcast, doing nothing about it");
    }

    public void handleCluster(String source, Cluster cluster) {
        System.out.println("cluster ready, rowNames " + cluster.getRowNames().length + " columnNames " + cluster.getColumnNames().length);
        this.clusterName = cluster.getName();
        this.clusterRowNames = cluster.getRowNames();
        this.clusterColumnNames = cluster.getColumnNames();
        this.defaultSpecies = cluster.getSpecies();
    }

    public String getClusterName() {
        if (this.clusterName != null) {
            return this.clusterName;
        }
        System.out.println("The R goose has not received a cluster broadcast.");
        return "";
    }

    public String[] getClusterRowNames() {
        if (this.clusterRowNames != null) {
            return this.clusterRowNames;
        }
        return new String[0];
    }

    public String[] getClusterColumnNames() {
        if (this.clusterColumnNames != null) {
            return this.clusterColumnNames;
        }
        return new String[0];
    }

    public void handleNetwork(String source, Network newNetwork) {
        System.out.println("network ready, node count " + newNetwork.getNodes().length + ", edges: " + newNetwork.edgeCount());
        this.network = newNetwork;
        this.defaultSpecies = newNetwork.getSpecies();
    }

    public void clearSelections() {
    }

    public int getSelectionCount() {
        return 0;
    }

    public String[] getGeeseNames() {
        ArrayList<String> results = new ArrayList<String>();
        for (String name : this.activeGeeseNames) {
            if (this.myGaggleName.equals(name)) continue;
            results.add(name);
        }
        return results.toArray(new String[0]);
    }

    public String getName() {
        return this.myGaggleName;
    }

    public void setName(String newName) {
        this.myGaggleName = newName;
    }

    public void setGeometry(int x, int y, int width, int height) {
    }

    public void doBroadcastList() {
    }

    protected void broadcastToGaggle(String species, String[] names) {
    }

    public void doHide() {
        System.out.println("doHide not implemented for the R goose");
    }

    public void doShow() {
        System.out.println("doShow not implemented for the R goose");
    }

    public void doExit() {
        this.connector.disconnectFromGaggle(false);
        System.out.println("No longer connected to the boss.");
        System.out.println("use the connectToGaggle() method to reconnect.");
    }

    void show(String name) {
        try {
            this.gaggleBoss.show(name);
        }
        catch (RemoteException rex) {
            System.err.println("error rmi at boss.show , from RShellGoose " + name);
        }
    }

    void hide(String name) {
        try {
            this.gaggleBoss.hide(name);
        }
        catch (RemoteException rex) {
            System.err.println("error rmi at boss.hide , from RShellGoose " + name);
        }
    }

    void broadcastAssociativeArray(GaggleTuple gaggleTuple) {
        gaggleTuple.setSpecies(this.defaultSpecies);
        try {
            this.gaggleBoss.broadcastTuple(this.myGaggleName, this.targetGoose, gaggleTuple);
        }
        catch (RemoteException rex) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
        }
    }

    public void setSpecies(String newValue) {
        this.defaultSpecies = newValue;
    }

    public String getSpecies() {
        return this.defaultSpecies;
    }

    public void broadcastList(String name, String broadcastName) {
        String[] names = new String[]{name};
        this.broadcastList(names, broadcastName);
    }

    public void broadcastList(String[] names, String broadcastName) {
        Namelist gaggleNameList = new Namelist();
        gaggleNameList.setName(broadcastName);
        gaggleNameList.setSpecies(this.defaultSpecies);
        gaggleNameList.setNames(names);
        try {
            this.gaggleBoss.broadcastNamelist(this.myGaggleName, this.targetGoose, gaggleNameList);
        }
        catch (RemoteException rex) {
            System.err.println("error rmi selecting at boss, from RShellGoose.broadcastList() " + this.myGaggleName);
        }
    }

    public void broadcastCluster(String clusterName, String rowNames, String[] columnNames) {
        String[] rowNamesArray = new String[]{rowNames};
        this.broadcastCluster(clusterName, rowNamesArray, columnNames);
    }

    public void broadcastCluster(String clusterName, String[] rowNames, String columnNames) {
        String[] columnNamesArray = new String[]{columnNames};
        this.broadcastCluster(clusterName, rowNames, columnNamesArray);
    }

    public void broadcastCluster(String clusterName, String rowNames, String columnNames) {
        String[] rowNamesArray = new String[]{rowNames};
        String[] columnNamesArray = new String[]{columnNames};
        this.broadcastCluster(clusterName, rowNamesArray, columnNamesArray);
    }

    public void broadcastCluster(String clusterName, String[] rowNames, String[] columnNames) {
        try {
            Cluster cluster = new Cluster(clusterName, this.getSpecies(), rowNames, columnNames);
            cluster.setSpecies(this.defaultSpecies);
            this.gaggleBoss.broadcastCluster(this.myGaggleName, this.targetGoose, cluster);
        }
        catch (RemoteException rex) {
            System.err.println("broadcast cluster error, in RShellGoose " + this.myGaggleName);
        }
    }

    void broadcastMatrix(DataMatrix matrix) {
        try {
            matrix.setSpecies(this.defaultSpecies);
            this.gaggleBoss.broadcastMatrix(this.myGaggleName, this.targetGoose, matrix);
        }
        catch (RemoteException rex) {
            System.err.println("error rmi selecting at boss, from RShellGoose.broadcastMatrix() " + this.myGaggleName);
        }
    }

    public void setTargetGoose(String gooseName) {
        this.targetGoose = gooseName;
    }

    public String getTargetGoose() {
        return this.targetGoose;
    }

    public void update(String[] gooseNames) {
        this.activeGeeseNames = gooseNames;
    }

    public void setConnected(boolean connected, Boss boss) {
        this.gaggleBoss = boss;
    }

    public void addNetworkMetadata(String key, String value) {
        this.networkMetadata.put(key, value);
    }

    public static void main(String[] args) throws Exception {
        new RShellGoose();
    }
}

