### Name: density,flowClust-method
### Title: Grid of Density Values for the Fitted t Mixture Model with
###   Box-Cox Transformation
### Aliases: density-method density,flowClust-method flowDens-class
###   density.flowClust
### Keywords: graphs

### ** Examples

res <- flowClust(iris[,1:4], K=3)

res.den <- density(res, data=iris)
plot(res.den)
plot(res.den, scale="sqrt", drawlabels=FALSE)
plot(res.den, type="image", nlevels=100)
plot(res.den, type="image", scale="sqrt", nlevels=100,
    color="gray")

plot(density(res, data=iris, subset=c("Petal.Length",
    "Petal.Width"), include=c(2,3)))
plot(density(res, subset=c(3,4), include=c(2,3), from=c(3,0.75),
    to=c(7,2.5)))



