### Name: findFC
### Title: A function to find the fold change between two experimental
###   conditions in a factorial experiment based on the linear model
###   parameter estimates.
### Aliases: findFC
### Keywords: models design

### ** Examples


data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]   
fit <- lm(exprs(estrogen)["33744_at",] ~ ES + TIME + ES*TIME)
betaNames <- names(coef(fit))
betas <- list(c("(Intercept)","ESP","TIME48h","ESP:TIME48h"),
                                        c("(Intercept)","ESP"))
coefs <- list(c(1,1,1,1),c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
findFC(fit,lambda[1,],lambda[2,],logbase=2)




